<?php defined('BASEPATH') || exit('No direct script access allowed');

/**
* Subscription_Type_Model
*/
class Subscription_Pack_Model extends CI_Model
{
	public $table = 'subscription_packs';
	
	function __construct()
	{
		parent::__construct();
	}

	public function insert()
	{
		$data = array(
			'subscription_pack_name' 	=> $this->input->post('subscription_pack_name'),
			'exam_standards' 			=> implode(',',$this->input->post('exam_standards')),
			'subscription_amount'		=> $this->input->post('subscription_amount'),
			'duration'					=> $this->input->post('duration'),
			'no_of_exams'				=> $this->input->post('no_of_exams')
		);

		return $this->db->insert($this->table, $data);
	}

	public function get( $subscription_pack_ID = null){
		if($subscription_pack_ID==null){
			$query = $this->db->get($this->table);
			return $query->result();
		}
		$query = $this->db->get_where($this->table,array('subscription_pack_ID' => $subscription_pack_ID));
		return $query->row();
	}

	public function update()
	{
		$data = array(
			'subscription_pack_name' 	=> $this->input->post('subscription_pack_name'),
			'exam_standards' 			=> implode(',',$this->input->post('exam_standards')),
			'subscription_amount'		=> $this->input->post('subscription_amount'),
			'duration'					=> $this->input->post('duration'),
			'no_of_exams'				=> $this->input->post('no_of_exams')
		);
		$this->db->where('subscription_pack_ID', $this->input->post('subscription_pack_id'));
		return $this->db->update($this->table,$data);
	}

	public function delete($subscription_pack_ID){
		return $this->db->delete($this->table, array('subscription_pack_ID' => $subscription_pack_ID ));
	}
}
